<?php
/**
 * NHT Trading Academy GetLinked Support Plugin
 *
 * @package NHT_Trading_Academy_GetLinked_Support_Plugin
 * @author New Horizon Technology Ltd.
 * @copyright 2024 New Horizon Technology Ltd.
 * @license All rights reserved.
 */

defined( 'ABSPATH' ) or die( 'Access Denied' );

/**
 * The function which flushes the permalinks on activation.
 */
function nht_trading_academy_get_linked_support_plugin_on_activation() {
	update_option( 'nht_trading_academy_get_linked_support_permalinks_flushed', 0 );
}
register_activation_hook( $nht_trading_academy_get_linked_support_plugin_file, 'nht_trading_academy_get_linked_support_plugin_on_activation' );

/**
 * Function which flushes the permalinks on deactivation.
 */
function nht_trading_academy_get_linked_support_plugin_on_deactivation() {
	flush_rewrite_rules( false );
}
register_deactivation_hook( $nht_trading_academy_get_linked_support_plugin_file, 'nht_trading_academy_get_linked_support_plugin_on_deactivation' );

/**
 * Function which flushes the permalinks on uninstallation.
 */
function nht_trading_academy_get_linked_support_plugin_on_uninstall() {
	delete_option( 'nht_trading_academy_get_linked_support_permalinks_flushed' );
	flush_rewrite_rules( false );
}
register_uninstall_hook( $nht_trading_academy_get_linked_support_plugin_file, 'nht_trading_academy_get_linked_support_plugin_on_uninstall' );
