<?php
/**
 * NHT Trading Academy GetLinked Support Plugin
 *
 * @package NHT_Trading_Academy_GetLinked_Support_Plugin
 * @author New Horizon Technology Ltd.
 * @copyright 2024 New Horizon Technology Ltd.
 * @license All rights reserved.
 */

defined( 'ABSPATH' ) or die( 'Access Denied' );

/**
 * The function which checks if there is an update available for the plugin.
 * Makes a request to https://getlinked-support.trading-academies.nht.io/version.json to check for updates.
 * Will be used in the "pre_set_site_transient_update_plugins" filter
 */
function nht_trading_academy_get_linked_support_plugin_check_for_update() {
	global $nht_trading_academy_get_linked_support_plugin_file;
	$request = wp_remote_get( 'https://getlinked-support.trading-academies.nht.io/version.json' );
	if ( is_wp_error( $request ) || wp_remote_retrieve_response_code( $request ) !== 200 ) {
		return null;
	}
	$body                = wp_remote_retrieve_body( $request );
	$current_plugin_data = get_plugin_data( $nht_trading_academy_get_linked_support_plugin_file );
	return (object) array(
		'id'           => plugin_basename( $nht_trading_academy_get_linked_support_plugin_file ),
		'slug'         => dirname( plugin_basename( $nht_trading_academy_get_linked_support_plugin_file ) ),
		'plugin'       => plugin_basename( $nht_trading_academy_get_linked_support_plugin_file ),
		'new_version'  => json_decode( $body )->version,
		'url'          => $current_plugin_data['PluginURI'],
		'package'      => json_decode( $body )->package,
		'requires'     => $current_plugin_data['RequiresWP'],
		'requires_php' => $current_plugin_data['RequiresPHP'],
	);
}

/**
 * The function which adds the update information to the transient.
 *
 * @param object $transient The transient object which contains the update information.
 */
function nht_trading_academy_get_linked_support_plugin_set_site_transient_update_plugins( $transient ) {
	global $nht_trading_academy_get_linked_support_plugin_file;
	$current_plugin_data = get_plugin_data( $nht_trading_academy_get_linked_support_plugin_file );
	$plugin_data         = nht_trading_academy_get_linked_support_plugin_check_for_update();
	if ( null === $plugin_data ) {
		return $transient;
	}
	if ( version_compare( $current_plugin_data['Version'], $plugin_data->new_version, '<' ) ) {
		$transient->response[ $plugin_data->plugin ] = $plugin_data;
	} else {
		$transient->no_update[ $plugin_data->plugin ] = $plugin_data;
	}
	return $transient;
}

add_filter( 'site_transient_update_plugins', 'nht_trading_academy_get_linked_support_plugin_set_site_transient_update_plugins' );

/**
 * The function which fixes the plugin information in the plugins API.
 *
 * @param false|object|array $value The result object or array. Default false.
 * @param string             $action The type of information being requested from the Plugin Installation API.
 * @param object             $args   Plugin API arguments.
 */
function nht_trading_academy_get_linked_support_plugin_set_plugins_api( $value, $action, $args ) {
	if ( 'plugin_information' === $action && 'nht-trading-academy-getlinked-support' === $args->slug ) {
		wp_redirect( 'https://getlinked-support.trading-academies.nht.io/' );
		exit;
	}
	return $value;
}

add_filter( 'plugins_api', 'nht_trading_academy_get_linked_support_plugin_set_plugins_api', 10, 3 );
